/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;

public class BlockPotion
extends AbstractPotion {
    public static final String POTION_ID = "Block Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Block Potion");
    public static final String NAME = BlockPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = BlockPotion.potionStrings.DESCRIPTIONS;

    public BlockPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.S, AbstractPotion.PotionColor.BLUE);
        this.potency = 12;
        this.description = DESCRIPTIONS[0] + this.potency + DESCRIPTIONS[1];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
        this.tips.add(new PowerTip(TipHelper.capitalize(GameDictionary.BLOCK.NAMES[0]), GameDictionary.keywords.get(GameDictionary.BLOCK.NAMES[0])));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new GainBlockAction(AbstractDungeon.player, AbstractDungeon.player, this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new BlockPotion();
    }
}

